# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import *
from .sdmodule import *
from .sdvaluestring import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDModuleMgr(SDAPIObject):
    """
    Keep track of all available SDModule. There is only one SDModuleMgr, that you can retrieve from the SDApplication
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDModuleMgr
        """
        super(SDModuleMgr, self).__init__(APIContext, handle, *args, **kwargs)

    def getModules(self) -> SDArray[SDModule]:
        """
        Get all available SDModule

        """
        outSDModuleArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDModuleMgr_getModules(self.mHandle, ctypes.byref(outSDModuleArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDModuleArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDModuleArray.value, ownHandle=True)

    def getModuleFromId(self, sdModuleId : str) -> Optional[SDModule]:
        """
        Get the SDModule that matches the specified identifier

        :param sdModuleId: The identifier of the SDModule to retrieve
        """
        outSDModule = ctypes.c_void_p()
        _res = self.mAPIContext.SDModuleMgr_getModuleFromId(self.mHandle, ctypes.create_string_buffer(sdModuleId.encode('utf-8')), ctypes.byref(outSDModule))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDModule, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDModule.value, ownHandle=True)

    def addRootPath(self, moduleIdPrefix : str, path : str) -> None:
        """
        Add a root path. For MDL, all MDL Modules (i.e. ".mdl" files) under this path will be added

        :param moduleIdPrefix: The prefix used to specify which technology is concerned. Ex: "mdl"
        :param path: The path of the directory to add
        """
        _res = self.mAPIContext.SDModuleMgr_addRootPath(self.mHandle, ctypes.create_string_buffer(moduleIdPrefix.encode('utf-8')), ctypes.create_string_buffer(path.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def removeRootPath(self, moduleIdPrefix : str, path : str) -> None:
        """
        Remove a root path

        :param moduleIdPrefix: The prefix used to specify which technology is concerned. Ex: "mdl"
        :param path: The path of the directory to remove
        """
        _res = self.mAPIContext.SDModuleMgr_removeRootPath(self.mHandle, ctypes.create_string_buffer(moduleIdPrefix.encode('utf-8')), ctypes.create_string_buffer(path.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getRootPaths(self, moduleIdPrefix : str) -> SDArray[SDValueString]:
        """
        Get all the root path registered

        :param moduleIdPrefix: The prefix used to specify which technology is concerned. Ex: "mdl"
        """
        outRootPaths = ctypes.c_void_p()
        _res = self.mAPIContext.SDModuleMgr_getRootPaths(self.mHandle, ctypes.create_string_buffer(moduleIdPrefix.encode('utf-8')), ctypes.byref(outRootPaths))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outRootPaths, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outRootPaths.value, ownHandle=True)

